package cn.com.duiba.kjy.api.enums.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/1/6 8:18 PM
 */
public enum RefundStatusEnum {

    INIT(1, "初始化状态"),
    ORDER_FAILED(2, "第三方退款申请失败"),
    ORDER_SUCCEEDED(3, "第三方退款申请成功"),
    SUCCEEDED(4, "退款成功"),
    FAILED(5, "退款失败"),

    //客集集自定义状态
    KJJ_DUIBA_ERROR(21, "调用兑吧失败"),
    ;

    private Integer code;
    private String desc;

    RefundStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, RefundStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(RefundStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static RefundStatusEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static ChargeStatusEnum getChargeStatusEnum(Integer code) {
        RefundStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return null;
        }
        if (isRefundSuccess(code)) {
            return ChargeStatusEnum.REFUND_SUCCESS;
        }
        if (isRefundFail(code)) {
            return ChargeStatusEnum.REFUND_FAIL;
        }
        return null;
    }

    public static boolean isRefundSuccess(Integer code) {
        RefundStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == SUCCEEDED;
    }

    public static boolean isRefundFail(Integer code) {
        RefundStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum == FAILED || statusEnum == KJJ_DUIBA_ERROR || statusEnum == ORDER_FAILED;
    }

    public static boolean isFinal(Integer code) {
        RefundStatusEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return isRefundFail(code) || isRefundSuccess(code);
    }
}
