package cn.com.duiba.kjy.api.params.fission;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class FissionAwardContextQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 4814026191630694275L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 奖品id
     */
    private Long awardId;

    /**
     * 消息类型
     * @see cn.com.duiba.kjy.api.enums.fission.FissionChatTypeEnum
     */
    private Integer chatType;

    /**
     * 包含的消息类型集合
     */
    private List<Integer> containsChatTypes;

    /**
     * 不包含的消息类型集合
     */
    private List<Integer> notContainsChatTypes;

    /**
     * 消息阶段
     */
    private Integer chatStage;

    /**
     * 模板消息类型
     * @see cn.com.duiba.kjy.api.enums.fission.FissionAwardContextTemplateEnum
     */
    private Integer templateType;

    /**
     * 包含的消息阶段
     */
    private List<Integer> containsChatStage;
}
