package cn.com.duiba.kjy.api.dto.greeting;

import cn.com.duiba.kjy.api.enums.greeting.GreetingShareType;
import lombok.Data;

import java.io.Serializable;

/**
 * 贺卡分享配置
 * @author kjj mybatis generator
 * 2020-03-11
 */
@Data
public class ContentGreetingCardShareConfigDto implements Serializable {
    private static final long serialVersionUID = 15839091571782915L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 分享标题
     */
    private String title;

    /**
     * 分享副标题
     */
    private String smallTitle;

    /**
     * 分享小图
     */
    private String picUrl;

    /**
     * 有红包分享标题
     */
    private String redPacketTitle;

    /**
     * 有红包分享副标题
     */
    private String redPacketSmallTitle;

    /**
     * 有红包分享小图
     */
    private String redPacketPicUrl;

    /**
     * 分享占比权重
     */
    private Integer shareRatio;

    /**
     * 是否已删除，0：未删除1：已删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 分享配置类型，1：H5分享
     * @see GreetingShareType
     */
    private Integer shareType;

    /**
     * 有礼物分享标题
     */
    private String giftTitle;

    /**
     * 有礼物分享副标题
     */
    private String giftSmallTitle;

    /**
     * 有礼物分享小图
     */
    private String giftPicUrl;

}
