package cn.com.duiba.kjy.api.enums.push;

import org.apache.commons.lang3.StringUtils;

/**
 * 推送事件
 * @author lizhi
 * @date 2019/7/10 3:21 PM
 */
public enum  PushEventEnum {

    //推送事件类型， 推送类型
    //推送事件类型（S1、S2...），一定要产品定义！！！
    SUBSCRIBE_WELCOME("S1","关注公众号"),
    SUBSCRIBE_FROM_CONTENT("S2","通过内容页二维码关注公众号"),
    SUBSCRIBE_RECOMMEND("S3","新用户引导转发文章"),
    SCAN_PROM("S4","会销五折优惠码"),
    ACTIVATION("S5","开通会员"),
    VISIT_FIRST("S6","内容第一次访客来访"),
    VISIT_NON_FIRST("S7","内容非第一次访客来访"),
    ACTIVITY_FORM_SUBMIT("S8","活动表单提交"),
    PREFERENTIAL_INFORMATION("S9","优惠信息推送"),
    PRIVATE_CHAT_ACCESS("S10","进入聊天界面通知"),
    PRIVATE_CHAT_SEND("S11","聊天通知"),
    NON_SUBSCRIBE_VIP("D1","引导关注客集集VIP"),
    STATISTICS_DAY("D3","每日访问数据统计"),
    STATISTICS_WEEK("D4","每周访问数据统计"),
    DAILY("D5","早报推送"),
    EVENING("D6","晚安心语"),
    HOT_CONTENT("D7","热门文章"),
    DISTRIBUTION("V1","已邀请好友关注"),
    REWARDED("V2","获得奖励提醒"),
    ARRIVAL_ACCOUNT("V3","提现到账通知"),
    STATISTICS_VIP_INCOME("V4","每日收益推送"),
    UP_SP_VIP("V8","升级特权VIP会员推送"),
    UP_GOLD_VIP("V9","升级黄金VIP会员推送"),
    SUBSCRIBE_WELCOME_EXPAND("V11","新用户关注公众号-人脉拓展"),
    SUBSCRIBE_WELCOME_WELFARE("V12","新用户关注公众号-新人礼品"),
    INTERACTIVE_PUSH("S12","互动推送"),
    AFTERNOON_ACTIVITY("D8","午间推送"),
    DAILY_SIGN("D10","每日日签"),
    SELLER_CARD_REAL_TIME_PUSH("S13","名片实时推送"),
    FORWARD_CONTENT_PUSH("S14","客户转发素材通知"),
    FORWARD_SELLER_CARD_PUSH("S15","客户转发名片通知"),
    ACTIVITY_FORM_SUBMIT_NON_REAL_TIME("S17","活动表单提交-非实时"),
    ACTIVITY_FORM_SUBMIT_LOTTERY("S18","活动中奖"),
    WEEKLY_THUMBS_UP("S19","周报点赞"),
    LIKE_CONTENT_INTERACTION("S22","素材点赞通知"),
    LIKE_CARD_INTERACTION("S23","名片点赞通知"),
    SUBSCRIBE_VIP_NOVICE_TASK("V7", "关注公众号新人任务"),
    ACTIVITY_FORM_HAS_SOURCE("S24", "有内容来源的活动表单提交"),
    RECEIVE_INSURANCE("S31","私信领取赠险"),
    CLICK_CONTACT_PHONE("S28","点击电话联系"),
    CLICK_CONTACT_WX("S29","点击微信联系"),
    READING("S30","阅读完成"),
    CLICK_CONTACT("S32","点联系TA"),
    LIKE_CARD_INTERACTION_FROM_OTHER("S33","来自其它素材页的名片点赞通知"),
    SALES_PROMOTION_REMIND("S34","会销优惠结束前2小时，优惠提醒"),
    SALES_PROMOTION_CASE("S35","会销优惠结束48小时后，推送客集集案例"),
    SALES_PROMOTION("S36","会销优惠结束48小时后，推送限时优惠"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH1("S37", "定时推送文章1"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH2("S38", "定时推送文章2"),
    INCREASE_USER_CLUE_ACTIVITY("S39", "获得增员线索（小游戏）"),
    INVESTMENT_CLUE_ACTIVITY("S40", "获得投资线索（小游戏）"),
    INCREASE_USER_CLUE_ARTICLE("S41", "获得增员线索（文章）"),
    INVESTMENT_CLUE_ARTICLE("S42", "获得投资线索（文章）"),
    INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH3("S43", "定时推送文章3"),
    ACCURATE_MATERIAL_PUSH("S47","精准素材推送"),
    COLLECT_CONTENT_INTERACTION("S48","文章收藏通知"),
    ACTIVITY_ACCURATE_MATERIAL_PUSH("S49","活动精准线索推送"),
    SELLER_NOVICE_TASK_FINISH_PUSH("S50", "新手任务完成推送"),
    VISITOR_INCOME_PUSH("S53","文章底部用户收入推送"),
    MATERIAL_COMMENT_FROM_FRIEND_PUSH("S54","文章互动-收到一度人脉访客评论"),
    MATERIAL_COMMENT_FROM_EXTRA_FRIEND_PUSH("S55","文章互动-收到二度人脉访客评论"),
    INVITATION_ACCEPT_PUSH("S56","访客接受邀请函推送"),
    CHANGE_TO_LOCAL_DAILY("S71","换成本地早报"),
    COME_ON_BABY("S72","给我加个油"),
    POSITIVE_ENERGY("S73","获取正能量海报"),
    GOTO_COMPANY_AREA("S74","去公司专区"),
    AFTERNOON_OTHER_CONTENT("S75","换一批趣味素材"),
    AFTERNOON_COMPLETE_CARD("S76","完善名片"),
    AFTERNOON_OTHER_FUNCTION("S77","更多功能1"),
    AFTERNOON_INVITE("S78","邀请好友"),
    ONE_TIME_USE("S87","一次性推送"),
    VISITOR_BIRTHDAY_PUSH("S89", "12月运势推送生日"),
    ACCURATE_AGGREGATION_PUSH_CUST_LIST("S90","获查看客户名单"),

    HOT_CONTENT_CHANGE("S80","换一批热点新闻"),
    HOT_CONTENT_FIND("S82","潜在增员对象"),
    HOT_CONTENT_SHARE("S83","分享一篇正能量文章"),

    EVENING_CONTENT_SCHOOL("S84","商学院入口"),
    EVENING_CONTENT_FUNCTION("S85","看看有什么新功能1"),
    EVENING_CONTENT_WANAN("S86","道晚安"),

    EVENING_CONTENT_FUNCTION_1("S91","看看什么功能新功能主推送"),
    EVENING_CONTENT_FUNCTION_2("S92","看看有什么新功能2"),

    AFTERNOON_OTHER_FUNCTION_2("S93","更多功能2"),
    AFTERNOON_OTHER_FUNCTION_3("S94","更多功能3"),
    INVITATION_PUSH_ENTRY("S115","邀请函制作功能入口"),

    @Deprecated
    FISSION_TAKE_ACTIVITY("X1", "裂变：参与活动"),
    FISSION_SOMEONE_HELPED_ASSISTANCE("X2", "裂变：有好友帮你助力"),
    FISSION_ASSISTANCE_SUCCESS("X3", "裂变：助力完成，提醒领奖"),
    FISSION_ASSISTANCE_HELP_OTHER("X4", "裂变：帮好友助力"),
    FISSION_AGENT_TAKE_ACTIVITY("X5", "裂变：参与活动,通知代理人"),
    FISSION_AGENT_COMPLETE_ACTIVITY("X6", "裂变：有人完成,通知代理人"),
    FISSION_USER_NEW_MESSAGE("X8", "裂变:用户收到代理人私聊消息"),

    FISSION_SCAN("S61", "裂变：有人扫码"),
    FISSION_SCAN_AUDITION("S62", "裂变：扫码且试听"),
    FISSION_SCAN_WANT("S63", "裂变：扫码且想要"),
    FISSION_SCAN_WANT_SHARD("S64", "裂变：扫码且想要且分享"),
    FISSION_SCAN_WANT_AUDITION("S65", "裂变：扫码且想要且试听"),
    FISSION_SCAN_WANT_SHARD_AUDITION("S66", "裂变：扫码且想要且分享且试听"),
    FISSION_AGENT_NEW_MESSAGE("S120", "裂变：代理人收到用户私聊消息"),
    FISSION_CLICK_ADD_WECHAT_CARD("S121", "裂变点击加微信好友卡片"),

    PROMOTION_WILL_EXPIRE_REMIND("S140","占用的优惠码，有效期2天，进行推送提醒"),
    SUBSCRIBE_WELFARE_PUSH("S141","新关注公众号，延时2小时发送福利大礼包推送"),
    KEYWORD_MATERIAL_REPLY("S142","关键词回复，获取资料"),
    AFTER_PAY_SUCCESS_PUSH_VIP_QRCODE("S150","代理人成功开通会员后推送VIP会员二维码"),
    FIRST_SUBSCRIBE_VIP_ACCOUNT_CUSTOMER_IMAGE_PUSH("S151","VIP公众号首次关注推客服图片"),
    FIRST_SUBSCRIBE_VIP_ACCOUNT_GUIDE_PUSH("S152","VIP公众号首次关注引导"),

    PROMOTION_PAY_REMIND("S200","超过两个小时扫码没付费的用户，进行推送提醒"),

    GAME_TEMPLATE_LOTTERY("S300", "抽奖工具：参与抽奖聚合推送"),
    GAME_TEMPLATE_LOTTERY_CUSTOM("S301", "抽奖工具：中销售员指定奖品"),

    GAME_TEMPLATE_RECEIVED_CUSTOM("S302", "抽奖工具：领取销售员指定奖品"),
    SELLER_CARD_APPRAISE_PUSH("S320", "名片客户首次评价推送"),

    CUSTOMIZE_PUSH_1("Z1", "自定义推送"),
    CUSTOMIZE_PUSH_2("Z2", "自定义推送"),
    CUSTOMIZE_PUSH_3("Z3", "自定义推送"),
    CUSTOMIZE_PUSH_4("Z4", "自定义推送"),
    CUSTOMIZE_PUSH_5("Z5", "自定义推送"),
    CUSTOMIZE_PUSH_6("Z6", "自定义推送"),
    CUSTOMIZE_PUSH_7("Z7", "自定义推送"),
    CUSTOMIZE_PUSH_8("Z8", "自定义推送"),
    CUSTOMIZE_PUSH_9("Z9", "自定义推送"),
    CUSTOMIZE_PUSH_10("Z10", "自定义推送"),
    CUSTOMIZE_PUSH_11("Z11", "自定义推送"),
    CUSTOMIZE_PUSH_12("Z12", "自定义推送"),
    CUSTOMIZE_PUSH_13("Z13", "自定义推送"),
    CUSTOMIZE_PUSH_14("Z14", "自定义推送"),
    CUSTOMIZE_PUSH_15("Z15", "自定义推送"),

    INTERACT_WILL_EXPIRE_REMIND46("H1", "连续46小时未和公众号进行互动的用户推送"),
    INTERACT_WILL_EXPIRE_REMIND47("H2", "连续47小时50分钟未和公众号进行互动的用户推送"),
    INTERACT_EXPIRE_REMIND_MORNING("H3", "连续48小时未和公众号进行互动的用户-每日6:30推送"),
    INTERACT_WILL_EXPIRE_REMIND_NIGHT("H4", "连续48小时未和公众号进行互动的用户-每日17:30推送"),
    INTERACT_WILL_EXPIRE_REMIND46_REPLY("H5", "用户回复唤醒小客"),
    INTERACT_WILL_EXPIRE_REMIND47_REPLY("H6", "用户回复激活小客"),
    INTERACT_EXPIRE_REMIND_WHO_LOOK_ME("H7", "用户今天收到了48小时后唤醒（H3 or H4） 且 第一次打开【谁看过我】页面"),
    INTERACT_WILL_EXPIRE_REMIND_REPLY_WITHDRAW("H8", "用户回复马上提现"),
    @Deprecated
    INTERACT_WILL_EXPIRE_REMIND_REPLY_FORTUNE("H9", "用户回复获取运势"),

    WAKE_UP_PUSH_REPLY("H9","唤醒推送回复"),
    INTERACT_EXPIRE_REMIND_UNSUBSCRIBE_REPLY("H10", "沉睡用户唤醒推送退订回复"),
    TODAY_LUCK_EVENT_RELY("H11", "今日运势公众号回复推送"),
    TODAY_LUCK_EVENT_DAILY_RELY("H13", "早报中的今日运势公众号回复推送"),
    TODAY_LUCK_EVENT("H14", "今日运势推送"),
	INTERACT_EXPIRE_REMIND_BEYOND_LIMIT("H15", "唤醒客服接口下行条数超过上限的用户推送"),
    TODAY_LUCK_EVENT_AFTERNOON_RELY("H16", "午报中的今日运势公众号回复推送"),

    HOT_RECOMMEND_ARTICLE_REPLY("H17","热文推送查看同行都在转"),

    INTERACT_WILL_EXPIRE_REMIND46_REPLY_FOR_UNLOCK("H20","首次预警，解锁微信限制回复"),
    DAILY_SIGN_PIC("H21","每日日签图片回复"),
    WAKE_UP_CLUES_REPLY("H22","唤醒关键字线索回复"),
    WAKE_UP_ACTIVITY_REPLY("H23","唤醒关键字趣味测试回复"),
    WAKE_UP_STRATEGY_REPLY("H24","唤醒关键字使用攻略回复"),
    WAKE_UP_NO_CONTENT_REPLY("H25","唤醒关键字当日无内容回复"),

    //节日贺卡
    GREETING_CARD_RECEIVE("S123", "节日贺卡：访问收下了贺卡"),
    GREETING_CARD_THANKS("S122", "节日贺卡：访客答谢了代理人"),
    GREETING_CARD_MAKE_SUCCESS("S130", "节日贺卡制作完成"),
    GREETING_CARD_RECEIVE_TIMEOUT("S132", "节日贺卡访客领取红包超时"),
    GREETING_CARD_REFUND_SUCCESS("S133", "节日贺卡红包退款成功"),
    GREETING_CARD_REFUND_FAIL("S134", "节日贺卡红包退款失败"),
    GREETING_CARD_RECEIVE_SUCCESS("S128", "节日贺卡访客领取红包成功"),
    GREETING_CARD_CHARGE_SUCCESS("S131", "节日贺卡红包充值成功"),
    GREETING_CARD_VISITOR_VIEW("S135", "节日贺卡付费增长访客预览"),
    SUBSCRIBE_GREETING_CARD_PUSH("S136", "自然关注时推送贺卡引流"),
    GREETING_CARD_RECEIVE_THANKS("S129", "节日贺卡访客领取红包成功并答谢"),
    GREETING_CARD_RECEIVE_GIFT("S137", "节日贺卡访客领取了礼物"),
    GREETING_CARD_RECEIVE_GIFT_REPLENISH("S138", "节日贺卡访客通知代理人补货"),
    GREETING_CARD_RECEIVE_FAIL("S139","节日贺卡访客领取红包失败"),
	// 线索1.0
    DEPT_VISIT("S143", "深度访问"),
    FREQUENTLY_VISIT("S144", "累计访问"),
    SPECIAL_CUSTOMER_VISIT("S145", "特别关注客户访问"),
    FAQ_PRIVATE_VISIT("S146", "种草素材-FAQ&私信气泡"),
    PRODUCT_VISIT("S147", "访问产品文章"),
    CLUE_ACTIVITY_SUMIT_MATERIAL("S148", "线索游戏提交资料推送"),
    INSURANCE_VISIT("S149", "1个月内累计有效阅读3个保险类素访问事件"),
    ASK_EMPLOY_INFO("S154", "询问招聘类信息"),
    LOOK_OVER_COMPANY_INFO("S155", "查看公司信息"),
    REVENUE_TALK_MATERIAL("S156", "创说会留资"),
    CLUE_ACTIVITY_SUMIT_MATERIAL_2("S157", "线索游戏提交资料推送2"),
    CLUE_ACTIVITY_SUMIT_MATERIAL_3("S158", "线索游戏提交资料推送3"),
    FAQ_PRIVATE_VISIT_2("S159", "种草素材-FAQ&私信气泡2"),
    FAQ_PRIVATE_VISIT_3("S160", "种草素材-FAQ&私信气泡3"),
    RECRUIT_FAQ_VISIT("S161", "增员专题类FAQ"),
    LOOK_OVER_HEADWORD("S172", "种草正文内仅查看词条"),
    HEADWORD_FAQ_VISIT("S173", "查看词条并点击互助问答"),
    EXPLOSION_VOTE("S174", "参与种草素材文章内的投票"),
    LOOK_OVER_CLAIM_CASE("S175", "查看理赔案例"),
    LOOK_OVER_PRODUCT_ARTICLE("S183", "种草文章内的产品文章"),
    LOOK_OVER_FAQ("S182", "种草文章内的互助问答"),

    MORE_EVENING_CONTENT("S162", "晚安心语查看更多"),
    //贺卡发圈素材
    DAILY_SIGN_GREETING_PUSH("S152", "贺卡发圈素材"),
    //自动回复
    ALL_AUTO_REPLY("S310", "自动回复统一推送事件"),
    //自动回复临时定制
    GREETING_PUSH("S311", "女神节结贺卡发圈素材"),
    GREETING_PUSH_V2("S312", "女王节贺卡发圈素材"),
    POSTER_PUSH("S313", "进入精英讲堂海报"),
    POSTER_PUSH_V2("S314", "收听销售必听书海报"),

    //发圈素材
    CIRCLE_MATERIAL_PUSH("S163","每日发圈素材推送"),
    //销售客户生日提醒推送
    BIRTH_REMIND_PUSH("S170","生日提醒推送"),

    //节日提醒推送
    SELLER_HOLIDAY_REMIND_PUSH("S178", "客户节日提醒推送"),
    //自定义提醒推送
    SELLER_CUSTOM_REMIND_PUSH("S179", "客户自定义提醒推送"),


    VIP_TRANSFER_CONFIRM_PUSH("S171", "会员迁移确认推送"),

    INVITATION_LETTER_VISIT_PUSH("S319", "邀请函访问推送"),

    PRE_INSTALL_PUSH("L7","预设会员推送"),
    PRE_INSTALL_CARD_PUSH("L8","预设会员修改名片推送"),

    LIVE_USER_APPOINTMENT("L5", "直播开播用户订阅消息"),
    LIVE_USER_DRAW("L6", "访客领取权益订阅消息推送"),
    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME("L1","在直播配置的通知时间通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_BEFORE_BEGIN("L2","在直播开始前3分钟通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVING("L3","在直播开始中每20分钟通知一次代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVED("L4","在直播结束将统计数据发给代理人(客服)"),
    LIVE_OA_QR_CODE_RESOURCE("L9","直播公众号资料推送"),
    LIVE_OUT_LINK("L10","直播外部链接推送"),
    LIVE_AGENT_NEW_VISITOR_ADVICE("L11", "直播代理人有新访客咨询"),
    LIVE_PUSH_MANAGER("L12", "直播自定义推送"),
    LIVE_NOTIFY_AGENT_AUTO_REPLY("L13", "直播代理人自动回复"),
    LIVE_NOTIFY_AGENT_PRE_INSTALL("L14", "直播代理人激活成功"),
    LIVE_POSTER_AUTO_REPLY("L15", "直播代理人海报自动回复"),
    LIVE_POSTER_PRE_INSTALL("L16", "直播代理人海报激活成功"),
    LIVE_USER_APPOINTMENT_LOTTERY("L17", "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED("L18", "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE("L19", "直播开播用户订阅关注消息"),
    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START("L20", "开播前,非直播当天代理人邀请/预约数据统计推送"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START("L21", "开播前,代理人排行推送"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START("L22", "开播前,代理人邀请用户,每10分钟聚合推送"),
    LIVE_USER_APPOINTMENT_PRE_LOTTERY("L23", "直播前中奖通知"),
    LIVE_AGENT_VISITOR_PRE_LOTTERY("L24", "代理人访客直播前中奖通知"),
    LIVE_END_AGENT_CLUE_PUSH("L27", "直播结束给代理人发线索推送"),
    LIVE_END_AGENT_SPECIFY_AWARD_PAY_CODE_PUSH("L28", "直播结束给代理人推送指定中奖付款码"),

    LIVE_SPECIFY_AWARD_USER_PUSH("L25", "访客指定中奖通知推送"),
    LIVE_DRAW_AWARD_AGENT_PUSH("L26", "直播间开奖，中奖客户代理人聚合消息推送"),

    // boss看板
    SELLER_TEAM_PUBLISH_TASK("S167", "发布新任务通知"),
    SELLER_TEAM_MANUAL_TASK("S168", "手动提醒任务通知"),

    //文章上传
    SELLER_IMPORT_TASK_FINISH("S184","文章上传成功推送"),

    MATERIAL_CONTENT_PUSH("D11", "种草素材推送"),

    VIP_RENEW_REMIND("D12", "会员续费提醒"),

    GRASS_CONTENT_MATERIAL_MORNING_PUSH("D13", "每日早上的种草素材推送"),

    MATERIAL_CONTENT_PM_PUSH("D14", "种草素材下午场推送"),
    /**
     * 中奖奖励派发推送
     */
    SELLER_GIFT_PUSH("S190","中奖奖励派发推送"),
    /*
     * 每日唤醒 海报推送
     */
    DAILY_POSTERS_PUSH("S185","早报海报推送"),
    GRASS_CONTENT_POSTERS_PUSH("S186","种草素材海报推送"),
    HOT_ARTICLE_POSTERS_PUSH("S187","热文海报推送"),
    EVENING_POSTERS_PUSH("S188","晚安心语海报推送"),

    FAQ_ARTICLE_ASK("S191","种草素材内的faq点击咨询"),
    FAQ_COLUMN_ASK("S192","个人专栏内的faq点击咨询"),

    FAQ_VISIT_DETAIL("S193","种草素材内的faq详情点击"),
    FAQ_VISIT_ASK("S194","个人专栏内的faq点击咨询"),
    FAQ_VISIT_SCAN("S195","个人专栏内的faq扫描二维码"),
    FAQ_VISIT_ASK_EXTRA("S196","faq详情页点击咨询额外问题"),
    IMPORTANT_CLUE("S197","重要线索提醒"),
    WELFARE_INSURANCE("S198","赠险领取"),
    RISK_TEST("S199","风险评测重要线索")
    ;

    /**
     * 推送事件类型（值为推送需求中的推送ID）
     */
    private String eventType;

    /**
     * 推送事件描述
     */
    private String desc;

    PushEventEnum(String eventType, String desc) {
        this.eventType = eventType;
        this.desc = desc;
    }

    public String getEventType() {
        return eventType;
    }

    public String getDesc() {
        return desc;
    }

    public static PushEventEnum getByEventType(String pushEvent){
        if(StringUtils.isBlank(pushEvent)){
            return null;
        }
        for (PushEventEnum event :values()){
            if(StringUtils.equals(pushEvent,event.getEventType())){
                return event;
            }
        }
        return null;
    }
}
