package cn.com.duiba.kjy.api.remoteservice.honorary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.honorary.SellerHonoraryAlbumConfDetailDto;
import cn.com.duiba.kjy.api.dto.honorary.SellerHonoraryAlbumConfDto;
import cn.com.duiba.kjy.api.params.honorary.MyHonoraryAlbumParam;

import java.util.List;

/**
 * 荣誉相册配置 rpc 接口
 * @author liuchao1
 * @date 2020-04-20 13:49
 **/
@AdvancedFeignClient
public interface RemoteSellerHonoraryAlbumConfService {

    /**
     * 分页查询(包含统计数据)
     * @param param 分页查询参数
     * @return 代理人荣誉相册配置及统计数据集合
     */
    List<SellerHonoraryAlbumConfDetailDto> findDetailPage(MyHonoraryAlbumParam param);

    /**
     * 新增代理人荣誉相册配置及统计信息
     * @param dto 代理人荣誉相册配置
     * @return 主键
     */
    Long save(SellerHonoraryAlbumConfDto dto);

    /**
     * 根据主键更新
     * @param dto 代理人荣誉相册配置
     * @return 执行结果
     */
    int update(SellerHonoraryAlbumConfDto dto);

    /**
     * 根据主键查询（走缓存）
     * @param id 主键
     * @return 代理人荣誉相册配置
     */
    SellerHonoraryAlbumConfDto findByIdCache(Long id);

    /**
     * 根据主键查询详情（包含统计数据）
     * 统计数据不走缓存，配置信息走缓存
     * @param id 主键
     * @return 代理人邀请函配置及统计数据
     */
    SellerHonoraryAlbumConfDetailDto findDetailById(Long id);

}
