package cn.com.duiba.kjy.api.dto.honorary;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员荣誉相册配置表
 * @author kjj mybatis generator
 * 2020-02-18
 */
@Data
public class SellerHonoraryAlbumConfDto implements Serializable {

    private static final long serialVersionUID = 15820119616016820L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请函ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 代理人邀请函id，对应tb_seller_content.id
     */
    private Long scid;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 标题/主题
     */
    private String title;

    /**
     * 邀请函主图
     */
    private String mainUrl;

    /**
     * 配置状态，0-预览，1-正式
     * @see cn.com.duiba.kjy.api.enums.honorary.HonoraryConfStateEnum
     */
    private Integer confState;

    /**
     * 邀请函内容oss地址
     */
    private String honoraryUrl;

    /**
     * 类型
     * @see cn.com.duiba.kjy.api.enums.honorary.HonoraryTypeEnum
     */
    private Integer honoraryType;


    /**
     * 代理人海报图
     */
    private String posterImageUrl;

    /**
     * 首图链接
     */
    private String firstImageUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
