package cn.com.duiba.kjy.api.remoteservice.dailySign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.dailySign.DailySignConfigDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.PageQuery;

import java.util.Date;

/**
 * Created by xiaotian on 2019-12-17.
 */
@AdvancedFeignClient
public interface RemoteDailySignService {

    /**
     * 分页获取日签配置信息（管理后端使用）
     *
     * @param pageQuery
     * @return
     */
    Page<DailySignConfigDto> selectPage(PageQuery pageQuery);

    /**
     * 根据时间获取配置信息
     *
     * @param date
     * @return
     */
    DailySignConfigDto selectByPushTime(Date date);

    /**
     * 根据是否存在ID判断更新或者插入操作（管理后端使用）
     *
     * @param dailySignConfigDto
     * @return
     */
    boolean insertOrUpdate(DailySignConfigDto dailySignConfigDto);

    /**
     * 更改日签配置状态（管理后端功能）
     *
     * @param id
     * @return
     */
    boolean updateStatus(Long id, Integer status);


    /**
     * 根据ID获取配置信息
     *
     * @param id
     * @return
     */
    DailySignConfigDto findById(Long id);
}
