package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售客户排序类型
 * @Author chentiecheng
 * @Date 2020/6/6 3:54 下午
 */
public enum  SellerCustomerSortTypeEnum {
    NAME_FIRST_KEY(0,"名字首字母"),
    VISIT_COUNT_HIGH_TO_LOW(1,"访问次数从高到低"),
    VISIT_COUNT_LOW_TO_HIGH(2,"访问次数从低到高"),
    LAST_VISIT_TIME_NEAR_TO_FAR(3,"最近访问时间从近到远"),
    LAST_VISIT_TIME_FAR_TO_NEAR(4,"最近访问时间从远到近"),
    INTENTION_HIGH_TO_LOW(5, "意向度从高到低"),
    ;
    private Integer code;
    private String desc ;

    SellerCustomerSortTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
