package cn.com.duiba.kjy.api.enums.advice;

/**
 * @author xiaotian
 * @create 2020-08-17 10:46
 * @descript 话术类型
 */
public enum AdviceTypeEnum {

    /**
     * faq关联问答
     */
    FAQ_QUESTION(1, "faq关联问答"),
    /**
     * 咨询问题
     */
    ASK_QUESTION(2, "咨询问题"),
    /**|
     * 领取资料
     */
    GET_MATERIAL(3,"领取资料"),
    /**
     * 领取赠险
     */
    GET_INSURANCE(4,"领取赠险"),
    /**
     * 风险评测
     */
    RISK_TEST(5,"风险评测"),
    /**
     * 1V1定制
     */
    ONE_BY_ONE(6,"1V1定制")
    ;

    private Integer code;
    private String description;

    AdviceTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}
