package cn.com.duiba.kjy.api.enums.push;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-08-08 18:34
 * @description:
 */
public enum  PushManagerStateEnum {
    /**
     * 状态，1=等待推送、2=成功、3=失败、4=未开启、5=推送中
     */
    WAIT(1, "等待推送"),
    SUCCESS(2, "成功"),
    FAIL(3, "失败"),
    NOT_ENABLE(4, "未开启"),
    PUSHING(5, "推送中"),
            ;

    private Integer code;

    private String desc;

    PushManagerStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PushManagerStateEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (PushManagerStateEnum pushManagerStateEnum : values()) {
            if (Objects.equals(pushManagerStateEnum.getCode(), code)) {
                return pushManagerStateEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
