package cn.com.duiba.kjy.api.params.seller;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-07-09 10:32
 * @descript 代理人转发es Param
 */
@Data
public class SellerForwardEsParam implements Serializable {

    private static final long serialVersionUID = 2334108744428194327L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 排序方式
     */
    private Integer orderType;

    /**
     * 最后一条记录的最后转发时间
     */
    private Long lastForwardTime;

    /**
     * 最后一条记录内容id
     */
    private Long lastContentId;

    /**
     * 最后一条线索总数
     */
    private Long lastClueNum;

    /**
     * 最后一条访问总数
     */
    private Long lastVisitNum;

    /**
     * 内容类型
     */
    private List<String> contentTypes;

    /**
     * 是否是带来多度人脉的访问
     */
    private Integer isHasMoreRelation;

    /**
     * 每页大小
     */
    private Integer pageSize;

    /**
     * 是否有标题
     */
    private Integer isHasTitle;

}
