package cn.com.duiba.kjy.api.dto.sellerCase;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人个人案例
 * @Author chentiecheng
 * @Date 2020/8/31 10:44 上午
 */
@Data
public class SellerCaseDto implements Serializable {
    private static final long serialVersionUID = -752969515119286339L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户年龄
     */
    private Integer customerAge;

    /**
     * 保险类型
     * @see cn.com.duiba.kjy.api.enums.company.InsuranceCaseTypeEnum
     */
    private Integer insuranceType;

    /**
     * 理赔原因
     */
    private String claimReason;

    /**
     * 理赔金额
     */
    private String claimAmount;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 行业类型
     * @see cn.com.duiba.kjy.api.enums.company.CompanyTradeTypeEnum
     */
    private Integer tradeType;

    /**
     * 是否展示
     */
    private Boolean isShow;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
