package cn.com.duiba.kjy.api.enums.user;

/**
 * @auther: linjianhui
 * @date: 2020-09-21 15:13
 * @description: UserAvatarBean-对应的业务id
 */
public enum UserAvatarBizIdEnum {

    KJJ_AVATAR(1, "客集集基础业务"),
    KJJ_LIVE_AVATAR(2, "客集集直播"),
    ;

    /**
     * 对应的业务id
     */
    private Integer bizId;
    /**
     * 描述
     */
    private String desc;


    UserAvatarBizIdEnum(Integer bizId, String desc) {
        this.bizId = bizId;
        this.desc = desc;
    }

    public static UserAvatarBizIdEnum getBybizId(Integer bizId) {
        for (UserAvatarBizIdEnum enumVal : UserAvatarBizIdEnum.values()) {
            if (enumVal.getBizId().equals(bizId)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getBizId() {
        return bizId;
    }

    public String getDesc() {
        return desc;
    }
}
