package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.MessageConfigDto;
import cn.com.duiba.kjy.api.enums.MessageMarkEnum;
import cn.com.duiba.kjy.api.params.MessageConfigParam;

import java.util.List;

/**
 * Created by dugq on 2019-06-29.
 */
@AdvancedFeignClient
public interface RemoteMessageConfigService {
    MessageConfigDto selectOne(Long id);

    int update(MessageConfigParam record);

    Integer selectCount(MessageConfigParam pojo);

    int insert(MessageConfigParam pojo);

    Integer delete(Long id);

    MessageConfigDto selectByMarkAndOaId(MessageMarkEnum markEnum, Long oaId);

    /**
     * 根据marks和oaId批量获取消息配置
     *
     * @param marks marks
     * @param oaId oaId
     * @return 消息配置集合
     */
    List<MessageConfigDto> selectByMarksAndOaId(List<Integer> marks, Long oaId);

    List<MessageConfigDto> selectByMark(MessageMarkEnum markEnum);

    List<MessageConfigDto> selectList(MessageConfigParam pojo);
}
