package cn.com.duiba.kjy.api.remoteservice.marketing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.marketing.MarketingGiftDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.marketing.MarketingGiftSearchParam;

/**
 * @author liuchao1
 * @date 2020/2/22 16:45
 */
@AdvancedFeignClient
public interface RemoteMarketingGiftService {

    /**
     * 保存
     * @param dto 营销礼物信息
     * @return 主键id
     */
    Long save(MarketingGiftDto dto);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 营销礼物信息集合
     */
    Page<MarketingGiftDto> search(MarketingGiftSearchParam param);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 营销礼物信息
     */
    MarketingGiftDto findById(Long id);

    /**
     * 根据id修改营销礼物信息
     * @param dto 营销礼物信息
     * @return 是否修改成功
     */
    boolean update(MarketingGiftDto dto);
}
