package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiaotian
 * @date 2019-06-05
 */
@Data
@ToString
public class ContentSellerRelationDto implements Serializable {

    private static final long serialVersionUID = -133085679829326666L;
    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     *
     *销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     *
     *类型，1=销售员上传
     */
    private Integer relationType;

    /**
     * 导入任务id,对应tb_seller_import_task.id
     */
    private Long taskId;

    /**
     * 导入类型
     * @see cn.com.duiba.kjy.api.enums.ImportTypeEnum
     */
    private Integer importType;

    /**
     * 是否删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     */
    private Date gmtModified;

    /**
     *
     * 关联内容类型
     */
    private String contentType;
}
