package cn.com.duiba.kjy.api.dto.honorary;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户访问荣誉相册记录表
 * @author kjj mybatis generator
 * 2020-02-18
 */
@Data
public class VisitorHonoraryAlbumRecordDto implements Serializable {

    private static final long serialVersionUID = -3099322504733628910L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 邀请函ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 邀请函配置ID，对应tb_seller_honorary_album_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 受邀人姓名
     */
    private Integer viewNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
