package cn.com.duiba.kjy.api.enums.content;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description  早报素材类型
 * @date 2020/11/5 16:47
 */
public enum DailyTypeEnum {

    /**
     * 素材类型
     */
    HEADLINES("headlines", "头条聚光灯"),
    DOMESTIC_NEWS("domesticNews", "热点大事件"),
    SOCIETY("society", "社会民生"),
    GLOBAL("global", "国际新闻"),
    ECONOMICS("economics", "财经聚焦"),
    THINK("think", "深度思考"),
    ;

    private String type;

    private String desc;

    DailyTypeEnum(String code, String desc) {
        this.type = code;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, DailyTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(DailyTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static DailyTypeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }
}
