package cn.com.duiba.kjy.api.params.dailyPosters;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 每日唤醒推送海报配置
 * @Author chentiecheng
 * @Date 2020/6/16 2:47 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GallerySearchParams extends PageQuery {
    private static final long serialVersionUID = 6879826615851478041L;


    /**
     * 图库类型，1：早安图库 2:晚安图库
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.GalleryTypeEnum
     */
    @NotNull(message = "图库类型不能为空")
    private Integer galleryType;

    /**
     * 图库分类
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.GalleryClassifyEnum
     */
    private Integer galleryClassify;

    /**
     * 是否推荐
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.RecommendEnum
     */
    private Integer recommend;
}
