package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAwardTemplateDto;

import java.util.List;

/**
 * @author 刘超
 * @date 2019/12/10 17:51
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteFissionAwardTemplateService {

    /**
     * 根据奖品id分页查询模板消息
     * @param awardId 奖品ID
     * @param pageNo 页码
     * @param pageSize 每页条数
     * @return 奖品快捷回复集合
     */
    List<FissionAwardTemplateDto> findByAwardId(Long awardId, Integer pageNo, Integer pageSize);

    /**
     * 根据奖品ID查询
     * @param awardId 奖品ID
     * @return 奖品快捷回复集合
     */
    List<FissionAwardTemplateDto> findListByAwardId(Long awardId);

    /**
     * 根据奖品ID批量物理删除，然后批量新增
     * @param awardId 奖品ID
     * @param dtoList 奖品快捷回复集合
     * @return 执行结果
     */
    int saveAfterDelete(Long awardId, List<FissionAwardTemplateDto> dtoList);
}
