package cn.com.duiba.kjy.api.dto.billing;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 代理人开单打卡表dto
*/
@Data
public class BillingClockDto implements Serializable {

    private static final long serialVersionUID = -1475040708748785286L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 代理人ID
    */
    private Long sellerId;

    /**
    * 状态 1:进行中 2:完成 3:失败 4:领取奖励
     * @see cn.com.duiba.kjy.api.enums.billing.BillingClockTaskStatusEnum
    */
    private Integer taskStatus;

    /**
    * 补卡次数
    */
    private Integer reissueTimes;

    /**
    * 已使用补卡次数
    */
    private Integer usedReissueTimes;

    /**
    * 创建时间
    */
    private Date gmtCreate;


}

