package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockDayStateDto;

import java.util.List;


/**
 * 60天开单打卡每天任务状态remote
 * @author zhanghuifeng
 * date 2020/11/17-17:22
 */
@AdvancedFeignClient
public interface RemoteBillingClockDayStateService {

    /**
     * 根据代理人ID和需要完成时间查询当天任务信息
     * @param needFinishDay 任务需要完成时间
     * @param sellerId 代理人ID
     * @return 任务信息
     */
    BillingClockDayStateDto findBySellerAndFinishDay(Integer needFinishDay, Long sellerId);

    /**
     * 根据代理人ID查询
     * @param sellerId 代理人ID
     * @return 每日任务状态列表
     */
    List<BillingClockDayStateDto> findBySeller(Long sellerId);
}
