package cn.com.duiba.kjy.api.remoteservice.sellercard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.sellercard.AuthenticationDto;
import cn.com.duiba.kjy.api.dto.sellercard.CaseDto;
import cn.com.duiba.kjy.api.dto.sellercard.SellerAuthRecordDto;
import cn.com.duiba.kjy.api.dto.sellercard.SellerCardDto;
import cn.com.duiba.kjy.api.dto.sellercard.SellerSplendidImageBean;
import cn.com.duiba.kjy.api.dto.sellercardv5.SellerCardBottomOfArticleDto;
import cn.com.duiba.kjy.api.dto.sellercardv5.SellerCardDtoV5;
import cn.com.duiba.kjy.api.dto.sellercardv5.SellerCardPersonalProfileDto;
import cn.com.duiba.kjy.api.dto.sellercardv5.SellerCardTopOfArticleDto;
import cn.com.duiba.kjy.api.dto.sellercardv5.SellerCardTopOfDetailDto;
import cn.com.duiba.kjy.api.enums.sellercard.AuthStatusEnum;
import cn.com.duiba.kjy.api.params.sellercard.SellerAuthRecordParam;
import cn.com.duiba.kjy.api.params.sellercard.SellerCardParam;

import java.util.List;

/**
 * Created by dugq on 2019-08-01.
 */
@AdvancedFeignClient
public interface RemoteSellerCardService {


    /**
     * 跟新名片
     * card更像是seller表的扩展表。
     * 广义上不存在插入。只有销售有没有编辑过扩展信息而已。
     * @param param
     * @return
     */
    int update(SellerCardParam param);

    /**
     * 仅允许未提交过审核，或者审核失败的情况下提交审核
     * 分布式锁，避免同一类型重复提交而导致一些诡异的问题
     * @param param
     * @return  -1 ：已经有提交记录了，不可再提交  -2 已经通过了，不可再次提交
     */
    @Deprecated
    int addAuth(SellerAuthRecordDto param);


    /**
     * 字符串会反序列化为对象
     * 缓存1分钟。
     * 跟新操作会清理缓存
     * @param sellerId
     * @return
     */
    SellerCardDto selectBySellerId(Long sellerId);

    /**
     * 转发前使用。
     * @param sellerId
     * @return
     */
    Long getScId(Long sellerId);

    /**
     * 管理端查询记录
     * @param param
     * @return
     */
    List<SellerAuthRecordDto> selectAuthRecordList4Admin(SellerAuthRecordParam param);

    Long selectAuthRecordCount4Admin(SellerAuthRecordParam param);

    /**
     * 获取销售提交的申请记录。每个类型取最近一次的提交记录
     * @param sellerId
     * @return
     */
    List<SellerAuthRecordDto> selectAuthRecordBySellerGroupByType(Long sellerId);

    /**
     * 根据代理人获取认证信息
     * @param sellerId
     * @return
     */
    List<SellerAuthRecordDto> selectAuthRecordBySeller(Long sellerId);


    /**
     * 数据存与hbase中，key存在card表的splendidImage
     * 每个card会有一个key。key是根据规则生成的
     * @param sid
     * @param url
     * @return
     */
    int updateSplendidImage(Long sid, String url);


    /**
     * 更新审核状态
     * @param id
     * @param authStatusEnum
     * @return
     */
    int updateSellerAuthRecordStatus(Long id, AuthStatusEnum authStatusEnum);

    /**
     * 根据主键Id获取名片详情 并补充代理人个人形象,公司名,中文名信息
     * @param id
     * @return
     */
    SellerCardDto selectSimpleDtoById(Long id);

    /**
     * 审核失败结果 标记为已读
     * @param id
     * @return
     */
    @Deprecated
    int readAuthResult(Long id,AuthStatusEnum authStatusEnum);

    /**
     * 是否为完善的代理人名片
     * @param sellerId
     * @return
     */
    Boolean isPerfect(Long sellerId);

    /**
     * 获取代理人名片完善度百分比  全部完成返回 100
     * @param sellerId
     * @return
     */
    Integer getCompeletePercent(Long sellerId);

    /**
     * 根据id查询审核记录
     * @param ids
     * @return
     */
    List<SellerAuthRecordDto> selectAuthRecordByIds(List<Long> ids);


    /**
     * 获取代理人名片 点滴精彩分页查询
     * @param sellerId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    SellerSplendidImageBean getSellerSplendidImage(Long sellerId, Integer pageIndex, Integer pageSize);

    /**------名片5.2.0后 接口模块化-------**/

    /**
     * 获取tb_seller_card dto对象
     * @param sellerId
     * @return
     */
    SellerCardDtoV5 getSimpleDtoBySellerId(Long sellerId);

    /**
     * 获取名片顶部详情页信息
     * @param sellerId
     * @return
     */
    SellerCardTopOfDetailDto getTopOfDetail(Long sellerId);

    /**
     * 个人介绍模块
     * @param sellerId
     * @return
     */
    SellerCardPersonalProfileDto getPersonalProfile(Long sellerId);

    /**
     * 素材顶部名片
     * @param sellerId
     * @return
     */
    SellerCardTopOfArticleDto getSellerCardTopOfContent(Long sellerId);

    /**
     * 素材底部名片
     * @param sellerId
     * @return
     */
    SellerCardBottomOfArticleDto getSellerCardBottomOfContent(Long sellerId);

    /**
     * 获取证书荣誉
     * @param sellerId
     * @return
     */
    List<AuthenticationDto> getAuthenticationDto(Long sellerId);

    /**
     * 更新名片截图
     * @param sellerId
     * @param url
     * @return
     */
    Boolean updateSellerScreenShot(Long sellerId,String url);


}
