package cn.com.duiba.kjy.api.remoteservice.survey;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.survey.SurveySubmitResultDto;
import cn.com.duiba.kjy.api.dto.survey.SurveyUserRecordDto;
import cn.com.duiba.kjy.api.params.survey.SurveySubmitParam;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/11/26 15:27
 */
@AdvancedFeignClient
public interface RemoteSurveyService {

    /**
     * 提交答案
     * @param param 用户提交的答案信息
     * @return 用户提交答案记录id
     * @throws KjyCenterException 异常信息
     */
    SurveySubmitResultDto submit(SurveySubmitParam param);

    /**
     * 查询用户问券填写记录
     * @param surveyId 问卷id
     * @param consumerId 用户id，必传
     * @return 是否提交过答案
     */
    SurveyUserRecordDto findUserRecord(Long surveyId, Long consumerId);
}
