package cn.com.duiba.kjy.api.enums.dailyPosters;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linjianhui
 * @description 早晚安图库置顶
 * @date 2020/11/13 14:08
 */
public enum StickStateEnum {

    /**
     * 0：未置顶，1:置顶
     */
    NO_ON_TOP(0, "未置顶"),
    ON_TOP(1, "置顶"),
    ;

    private Integer code;
    private String desc;

    StickStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, StickStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(StickStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static StickStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
