package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.OfficialAccountDto;

import java.util.List;

/**
 * Created by dugq on 2019-06-01.
 */
@AdvancedFeignClient
public interface RemoteOfficialAccountService {
    OfficialAccountDto selectOne(Long id);

    OfficialAccountDto selectByAppId(String appId);

    OfficialAccountDto selectBySourceId(String sourceId);

    OfficialAccountDto selectMainOAByType(Integer oaType);

    List<OfficialAccountDto> selectList(OfficialAccountDto pojo);

    int update(OfficialAccountDto record);

    Integer selectCount(OfficialAccountDto pojo);

    int insert(OfficialAccountDto pojo);

    int enable(Long id, Boolean enable);

    Integer delete(Long id);

    /**
     * 根据oatypes查询公众号列表
     * @param oaTypes
     * @return
     */
    List<OfficialAccountDto> selectByOaTypes(List<Integer> oaTypes);

    /**
     根据id集合查询
     *
     */
    List<OfficialAccountDto> selectByIds(List<Long> ids);

    /**
     * manager测试修复数据专用，禁止挪作他用
     * @param oaId
     * @return
     */
    @Deprecated
    int deleteAllUserInOa(Long oaId);

    /**
     * 获取所有的开启状态的 公众号的id列表
     * @return
     */
    List<Long> getAllOpenOaIds();
}
