package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-29.
 * 消息配置的标记。一个功能一个标记。切勿重复哦
 */
public enum MessageMarkEnum {
    /**
     * 公众号、小程序消息配置
     */
    DAILY_TEMPLATE(1,"日报降级"),
    VISIT_TEMPLATE(2,"访问记录降级"),
    BUY_VIP_TEMPLATE(3,"会员购买成功"),
    SHARE_STATISTICS_TEMPLATE(4,"每日统计"),
    EVENING_GREETING_TEMPLATE(5,"晚安问候降级"),
    RETURN_MONEY(6,"收益发放通知"),
    WITHDRAW_MONEY(7,"提现成功通知"),

    VIP_INCOME_STATISTICS_TEMPLATE(8,"每日收益模板消息"),
    GUIDING_SUBSCRIBE_VIP(9,"引导关注VIP客服消息"),
    EVENING_GREETING_KEFU(10,"晚安问候客服消息"),
    USER_IN_CHAT_PAGE(11,"客户咨询客服消息通知，客户首次进入该会话聊天页"),
    USER_IN_CHAT_PAGE_TEMPLATE(12,"客户咨询模板消息通知，客户首次进入该会话聊天页"),
    USER_SEND_MESSAGE(13,"用户咨询客服消息通知，客户给代理人留言"),
    USER_SEND_MESSAGE_TEMPLATE(14,"用户咨询模板消息通知，客户给代理人留言"),
    USER_RECEIVE_MESSAGE(15,"客户接收代理人留言客服消息通知，客户消息小程序"),
    UPGRADE_GRADE_TEMPLATE(16,"等级升级通知"),
    ORDER_SEND_OUT(17,"订单发货通知"),

    AFTERNOON_ACTIVITY_KEFU(18,"下午动画推荐客服消息"),
    AFTERNOON_ACTIVITY_TEMPLATE(19,"午间动画推荐降级"),

    PRIVATE_CHAT_TEMPLATE(20,"代理人回复私聊，小程序模版消息"),

    SALES_PROMOTION_ONE_TEXT(21,"会销未付款用户22小时客服文字消息"),
    SALES_PROMOTION_TWO_TEXT(22,"会销未付款用户48小时客服文字消息"),
    SALES_PROMOTION_REMIND_PIC(23,"会销未付款用户48小时客服图文消息"),
    HOT_CONTENT_TEMPLATE(24, "热点内容模版消息"),
    COLLECT_CONTENT_INTERACTION(25, "收藏通知消息"),
    ACTIVITY_ACCURATE_CLUE(26, "活动精准线索推送"),
    ACCURATE_CLUE_TEMPLATE(27, "精准线索模版推送"),

    EVENING_GREETING_TEMPLATE_TEST(29,"晚安问候降级测试"),

    FISSION_SOMEONE_HELPED_ASSISTANCE(30, "裂变：有好友帮你助力"),
    FISSION_ASSISTANCE_HELP_OTHER(31, "裂变：帮好友助力"),
    FISSION_ASSISTANCE_SUCCESS(32, "裂变：助力完成，提醒领奖"),
    FISSION_AGENT_TAKE_ACTIVITY(33, "裂变：参与活动,通知代理人"),
    FISSION_TAKE_ACTIVITY(34, "裂变：参与活动"),
    FISSION_AGENT_COMPLETE_ACTIVITY(35, "裂变：有人完成,通知代理人"),
    FISSION_AGENT_MULTIPLE_MESSAGE(36, "裂变：代理人综合消息"),
    FISSION_USER_RECEIVE_MESSAGE(37, "裂变：用户收到代理人的私聊消息"),
    FISSION_SELLER_RECEIVE_MESSAGE(43, "裂变：代理人收到用户的私聊消息"),

    SINGLE_MESSAGE_USE(38, "自定义推送1"),
    EARLY_WARNING_REMIND_TEMPLATE(39,"预警提醒"),

    CUSTOM_MESSAGE_SEND(40,"自定义内容推送模版降级"),
    AFTERNOON_CONTENT_PUSH(41,"12点内容推送"),

    TEST_REPORT_TEMPLATE(45,"测算报告通知"),


    GAME_TEMPLATE_LOTTERY(50, "抽奖工具：参与抽奖聚合推送"),
    GAME_TEMPLATE_LOTTERY_TEMPLATE(57, "抽奖工具：参与抽奖聚合推送降级模板"),
    GAME_TEMPLATE_LOTTERY_CUSTOM(51, "抽奖工具：中销售员指定奖品"),
    GAME_TEMPLATE_LOTTERY_CUSTOM_TEMPLATE(58, "抽奖工具：中销售员指定奖品降级模板"),
    GAME_TEMPLATE_RECEIVED_CUSTOM(52, "抽奖工具：领取销售员指定奖品"),
    GAME_TEMPLATE_RECEIVED_CUSTOM_TEMPLATE(53, "抽奖工具：领取销售员指定奖品降级模板"),
    EVENING_GREETING_CUSTOM_TEXT(54, "晚安心语客服文字消息"),

    TODAY_LUCK_CUSTOM_TEXT(55, "今日运势推送"),

    INTERACT_REMIND_TEMPLATE(56,"唤醒:模版推送"),

    /**
     * 自定义推送模版占用 60-70.具体模版名称在备注中。根据实际情况选择性，动态配置
     */
    CUSTOM_PUSH_TEMPLATE_2(60, "自定义推送2"),
    CUSTOM_PUSH_TEMPLATE_3(61, "自定义推送3"),
    CUSTOM_PUSH_TEMPLATE_4(62, "自定义推送4"),
    CUSTOM_PUSH_TEMPLATE_5(63, "自定义推送5"),
    CUSTOM_PUSH_TEMPLATE_10(70, "自定义推送10"),

    GREETING_CARD_RECEIVE(75, "节日贺卡：访客收下了贺卡"),
    GREETING_CARD_RECEIVE_DEMOTION(76, "节日贺卡：访客收下了贺卡降级模板"),
    GREETING_CARD_THANKS(77, "节日贺卡：访客答谢了贺卡"),
    GREETING_CARD_THANKS_DEMOTION(78, "节日贺卡：访客答谢了贺卡降级模板"),
    GREETING_CARD_MAKE_SUCCESS(79, "节日贺卡：制作完成"),
    GREETING_CARD_MAKE_SUCCESS_DEMOTION(80, "节日贺卡：制作完成降级模板"),

    GREETING_CARD_RECEIVE_GIFT(81, "节日贺卡：访客领取了礼物"),
    GREETING_CARD_RECEIVE_GIFT_DEMOTION(82, "节日贺卡：访客领取了礼物降级模板"),
    GREETING_CARD_RECEIVE_GIFT_REPLENISH(83, "节日贺卡：访客通知代理人补货"),
    GREETING_CARD_RECEIVE_GIFT_REPLENISH_DEMOTION(84, "节日贺卡：访客通知代理人补货降级模板"),
    GREETING_CARD_RECEIVE_TIMEOUT(86, "节日贺卡：访客领取红包超时"),
    GREETING_CARD_RECEIVE_TIMEOUT_TEMPLATE(87, "节日贺卡：访客领取红包超时降级模板"),
    GREETING_CARD_REFUND_SUCCESS(88, "节日贺卡：代理人红包退账成功"),
    GREETING_CARD_REFUND_SUCCESS_TEMPLATE(89, "节日贺卡：代理人红包退账成功降级模板"),
    GREETING_CARD_REFUND_FAIL(90, "节日贺卡：代理人红包退账失败"),
    GREETING_CARD_REFUND_FAIL_TEMPLATE(91, "节日贺卡：代理人红包退账失败降级模板"),
    GREETING_CARD_RECEIVE_SUCCESS(92, "节日贺卡：访客领取红包成功"),
    GREETING_CARD_RECEIVE_SUCCESS_DEMOTION(93, "节日贺卡：访客领取红包成功降级模板"),
    GREETING_CARD_CHARGE_SUCCESS(94, "节日贺卡：代理人充值成功"),
    GREETING_CARD_CHARGE_SUCCESS_DEMOTION(95, "节日贺卡：代理人充值成功降级模板"),
    GREETING_CARD_VISITOR_VIEW(96, "节日贺卡:付费增长访客预览"),
    GREETING_CARD_VISITOR_VIEW_TEMPLATE(97, "节日贺卡:付费增长访客预览降级模板"),
    GREETING_CARD_RECEIVE_THANKS(98, "节日贺卡：访客领取红包并答谢"),
    GREETING_CARD_RECEIVE_THANKS_DEMOTION(99, "节日贺卡：访客领取红包并答谢降级模板"),

    INVITATION_ACCEPT_DEMOTION(100,"邀请函：接受邀请函非VIP推送降级模版"),
    INVITATION_ACCEPT_VIP_DEMOTION(101,"邀请函：接受邀请函VIP推送降级模版"),
    INVITATION_ACCEPT_VIP_DEMOTION_NEW(103,"新邀请函：接受邀请函VIP推送降级模版"),


    DAILY_VIP_CUSTOMER_TEXT_BODY(110,"vip用户的早报消息体模版"),
    DAILY_CUSTOMER_TEXT_ARTICLE_LIST(112,"早报消息体中文章模版"),
    DAILY_GRASS_CONTENT_LIST(113,"早报消息体中种草文章模版"),

    HOT_CONTENT_PUSH_CUSTOM_BODY(114,"热文推送VIP保险版本客服消息体"),
    HOT_CONTENT_PUSH_CUSTOM_ARTICLE(119,"热文推送客服消息体中每条内容模版"),

    DAILY_SIGN_CUSTOMER_BODY(120,"日签"),
    GREETING_CARD_H5_CHARGE_SUCCESS(121, "节日贺卡：代理人h5充值成功"),
    GREETING_CARD_H5_CHARGE_SUCCESS_TEMPLATE(122, "节日贺卡：代理人h5充值成功降级模板"),
    GREETING_CARD_MAKE_H5_SUCCESS(123, "节日贺卡：H5制作完成"),
    GREETING_CARD_MAKE_H5_SUCCESS_TEMPLATE(124, "节日贺卡：H5制作完成降级模板"),

    SELLER_SURVEY_PUSH(125, "代理人问卷调查推送群发消息"),
    SELLER_CARD_APPRAISE_PUSH_MSG_VIP(126, "收到客户评价VIP推送"),
    SELLER_CARD_APPRAISE_PUSH_MSG_NOT_VIP(127, "收到客户评价非VIP推送"),
    SELLER_CARD_APPRAISE_PUSH_MSG_TEMPLATE(128, "收到客户评价模板消息"),

    GREETING_CARD_RECEIVE_FAIL(129, "节日贺卡：访客领取红包失败"),
    GREETING_CARD_RECEIVE_FAIL_TEMPLATE(130, "节日贺卡：访客领取红包失败降级模板"),

    INVITATION_LETTER_VISIT_PUSH(131, "邀请函访问vip推送"),
    INVITATION_LETTER_VISIT_PUSH_TEMPLATE(132, "邀请函访问vip推送降级模板"),

    DAILY_SIGN_CUSTOMER_TEMPLATE_BODY(133,"日签模版推送"),

    INVITATION_LETTER_VISIT_NOT_VIP_PUSH(134, "邀请函访问非vip推送"),
    INVITATION_LETTER_VISIT_NOT_VIP_PUSH_TEMPLATE(135, "邀请函访问非vip推送降级模板"),
    //生日提醒推送模版
    BIRTHDAY_REMIND_PUSH_TEMPLATE(136, "客户生日提醒推送模板"),

    LIVE_USER_APPOINTMENT(140, "直播开播用户订阅消息"),
    LIVE_USER_DRAW(141, "访客领取权益订阅消息推送"),
    LIVE_USER_APPOINTMENT_LOTTERY(142, "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED(143, "直播预约红包领取通知"),
    LIVE_USER_APPOINTMENT_SUBSCRIBE(144, "直播开播用户订阅关注消息"),
    LIVE_AGENT_VISITOR_PRE_LOTTERY(145, "代理人访客直播前中奖通知"),

    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME_CUSTOM(150,"在直播配置的通知时间通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_IN_NOTICE_TIME_TEMPLATE(151,"在直播配置的通知时间通知代理人(模版)"),

    LIVE_NOTIFY_AGENT_BEFORE_BEGIN_CUSTOM(152,"在直播开始前3分钟通知代理人(客服)"),
    LIVE_NOTIFY_AGENT_BEFORE_BEGIN_TEMPLATE(153,"在直播开始前3分钟通知代理人(模版)"),

    LIVE_NOTIFY_AGENT_WHEN_LIVING_CUSTOM(154,"在直播开始中每20分钟通知一次代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVING_TEMPLATE(155,"在直播开始中每20分钟通知一次代理人(模版)"),

    LIVE_NOTIFY_AGENT_WHEN_LIVED_CUSTOM(156,"在直播结束将统计数据发给代理人(客服)"),
    LIVE_NOTIFY_AGENT_WHEN_LIVED_TEMPLATE(157,"在直播结束将统计数据发给代理人(模版)"),

    SELLER_TEAM_REMIND_TEMPLATE(158, "boss任务看板通知模版消息"),

    LIVE_PRE_INSTALL_MESSAGE_CUSTOM(160,"直播预设会员指引推送"),

    LIVE_PRE_INSTALL_SUCCESS_MODIFY_CARD_CUSTOM(161,"直播预设会员激活成功推送完善名片"),

    /**
     * 种草素材推送
     */
    MATERIAL_CONTENT_PUSH_TEXT(162,"种草素材推送"),
    MATERIAL_CONTENT_PUSH_TEMPLATE(163,"种草素材推送降级模版"),

    VIP_RENEW_REMIND_FIRST(164,"会员续费第一次提醒"),
    VIP_RENEW_REMIND(165,"会员续费后续提醒"),
    VIP_RENEW_REMIND_FIRST_TEMPLATE(166,"会员续费第一次提醒降级模版"),
    VIP_RENEW_REMIND_TEMPLATE(167,"会员续费后续提醒降级模版"),

    //生日提醒推送(客服)
    SELLER_BIRTHDAY_REMIND_PUSH(170, "客户生日提醒推送客服消息"),
    //生日提醒推送(模板)
    SELLER_BIRTHDAY_REMIND_PUSH_TEMPLATE(171, "客户生日提醒推送模板消息"),
    //节日提醒推送(客服)
    SELLER_HOLIDAY_REMIND_PUSH(172, "客户节日提醒推送客服消息"),
    //节日提醒推送(模板)
    SELLER_HOLIDAY_REMIND_PUSH_TEMPLATE(173, "客户节日提醒推送模板消息"),
    //自定义提醒推送(客服)
    SELLER_CUSTOM_REMIND_PUSH(174, "客户自定义提醒推送客服消息"),
    //自定义提醒推送(模板)
    SELLER_CUSTOM_REMIND_PUSH_TEMPLATE(175, "客户自定义提醒推送模板消息"),
    /**
     * 唤醒推送
     */
    WAKE_UP_PUSH(176,"唤醒推送客服消息"),
    WAKE_UP_PUSH_TEMPLATE(177,"唤醒推送模版消息"),

    /**
     * 奖品派发
     */
    SELLER_GIFT_PUSH_TEXT(168,"奖品派发推送"),
    SELLER_GIFT_PUSH_TEMPLATE(169,"奖品派发奖励模版"),

    LIVE_NOTIFY_AGENT_HAS_NEW_VISITOR_ADVICE(178, "直播通知代理人有新的访客咨询"),
    LIVE_NOTIFY_AGENT_HAS_NEW_VISITOR_ADVICE_TEMPLATE(179, "直播通知代理人有新的访客咨询降级模板"),

    LIVE_AGENT_POSTER_LIVING_TEXT(180, "直播代理人海报直播中文字消息"),
    LIVE_AGENT_POSTER_LIVING_TEMPLATE(181, "直播代理人海报直播中文字消息降级模板消息"),
    LIVE_AGENT_POSTER_WAIT_TEXT(182, "直播代理人海报直播未开始文字消息"),
    LIVE_AGENT_POSTER_WAIT_TEMPLATE(183, "直播代理人海报直播未开始降级模板"),

    FAQ_IMPORTANT_TEMPLATE(184, "资料包扫描发送降级模版"),

    FAQ_IMPORTANT_ASK_TEMPLATE(185,"faq咨询推送降级模版"),

    FAQ_IMPORTANT_ASK_EXTRA_TEMPLATE(186,"faq额外问题咨询推送降级模版"),

    IMPORTANT_CLUE_TEMPLATE(187,"重要线索降级模版"),

    INSURANCE_CLUE_TEMPLATE(188,"领取赠险降级模版"),

    RISK_TEST_TEMPLATE(189,"风险评测降级模版"),

    LIVE_AGENT_STATISTIC_PUSH_BEFORE_START(190, "开播前,非直播当天代理人邀请/预约数据统计推送模板"),
    LIVE_AGENT_RANK_PUSH_BEFORE_START(191, "开播前,代理人排行推送模板"),
    LIVE_AGENT_INVITE_USER_PUSH_BEFORE_START(192, "开播前,代理人邀请用户,每10分钟聚合推送模板"),
    LIVE_END_AGENT_CLUE_PUSH(193, "直播结束给代理人发线索推送"),
    LIVE_END_AGENT_SPECIFY_AWARD_PAY_CODE_PUSH(194, "直播结束给代理人发送指定中奖付款码推送模板"),

    VIP_EXPIRED_RENEW_REMIND(200,"会员过期续费提醒"),
    VIP_EXPIRED_RENEW_REMIND_TEMPLATE(201,"会员过期续费提醒降级模版"),
    BILLING_CLOCK_REMIND_TEMPLATE(202,"60天打卡每日提醒模版"),
    BILLING_CLOCK_UNFINISH_REMIND_TEMPLATE(203,"当日任务未完成提示模板"),
    BILLING_CLOCK_REISSUE_REMIND_TEMPLATE(204,"补卡提示模板"),

    ;
    private Integer mark;
    private String desc;

    MessageMarkEnum(Integer mark, String desc) {
        this.mark = mark;
        this.desc = desc;
    }

    public Integer getMark() {
        return mark;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageMarkEnum Of(Integer type) {
        for (MessageMarkEnum e :values())
            if (Objects.equals(type, e.getMark())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息");
    }

}
