package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * 60天开单计划任务状态
 * @author zhanghuifeng
 * date 2020/11/17-11:13
 */
public enum BillingClockTaskStatusEnum {

    INIT(1, "进行中"),
    COMPLETE(2, "完成"),
    FAIL(3, "失败"),
    AWARD(4, "领取最终奖励"),

    ;

    private Integer code;
    private String desc;

    BillingClockTaskStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingClockTaskStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingClockTaskStatusEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingClockTaskStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
