package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.enums.billing.BillingClockAwardConfDetailDto;

import java.util.List;

/**
 * 60天开单打卡奖励配置明细service
 * @author zhanghuifeng
 * date 2020/11/19-13:49
 */
@AdvancedFeignClient
public interface RemoteBillingClockAwardConfDetailService {

    /**
     * 根据奖励配置ID查询奖励配置明细信息
     * @param awardConfId 奖励配置ID tb_billing_clock_award_conf主键ID
     * @return 明细
     */
    List<BillingClockAwardConfDetailDto> findByAwardConfId(Long awardConfId);

    /**
     * 根据奖励配置ID集合查询奖励配置明细信息
     * @param awardConfIds 奖励配置ID tb_billing_clock_award_conf主键ID
     * @return 列表
     */
    List<BillingClockAwardConfDetailDto> findByAwardConfIds(List<Long> awardConfIds);
}
