package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.constant.SellerVipEnum;
import cn.com.duiba.kjy.api.enums.order.IsPaidEnum;
import cn.com.duiba.kjy.api.enums.seller.InternalSellerEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerShowQrCodeTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author zhangshun
 * @description 销售信息
 * @date 2019-02-13
 */
@Data
@ToString
public class SellerDto implements Serializable {

    private static final long serialVersionUID = 1474342377011340192L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 销售员微信号
     */
    private String wechatNumber;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 备注
     */
    private String remark;

    /**
     * vip级别，0=不是、1=是
     */
    private Integer vip;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;

    /**
     * 我的二维码
     */
    private String qrCode;

    /**
     * 我的二维码
     */
    private String wechatQrCode;

    /**
     * 扩展字段
     */
    private String ext;

    /**
     * 客集集来源
     */
    private Integer accessSource;

    /**
     * 公司ID
     */
    private Long companyId;

    private SellerExtDto sellerExtDto;

    /**
     * 展示二维码类型
     * @see SellerShowQrCodeTypeEnum
     */
    private Integer showQrCodeType;

    /**
     * 是否付费 0-未付费 1-付费
     */
    private Integer isPaid;

    /**
     * 销售自定头像
     */
    private String avatar;

    /**
     * 英文名
     */
    private String englishName;

    /**
     * 自我介绍
     */
    private String personalIntro;

    /**
     * 是否是付费开通会员
     *
     * @return true-是，false-不是
     */
    public boolean isPayVip() {
        if (Objects.isNull(vip) || Objects.isNull(vipEndTime)) {
            return false;
        }

        if (!SellerVipEnum.VIP1.getCode().equals(vip) || new Date().after(vipEndTime)) {
            return false;
        }
        return IsPaidEnum.IS_PAID.getStatus().equals(isPaid);
    }

    /**
     * 是否是有效会员
     *
     * @return true-是，false-不是
     */
    public boolean isVip() {
        if (Objects.isNull(vip) || Objects.isNull(vipEndTime)) {
            return false;
        }

        return SellerVipEnum.VIP1.getCode().equals(vip) && !new Date().after(vipEndTime);
    }

    /**
     * 从业时长
     */
    private Integer exprLength;

    /**
     * 生日
     */
    private String birth;

    /**
     * 城市
     */
    private String city;

    /**
     * 省/家乡
     */
    private String hometown;

    /**
     * 是否使用自定义公司
     */
    private Integer isCustomCompany;

    /**
     * 是否是内部销售
     * @see InternalSellerEnum
     */
    private Integer internalSeller;

}
