package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockAwardConfDto;
import cn.com.duiba.kjy.api.enums.billing.BillingClockAwardConfTypeEnum;

import java.util.List;

/**
 * 60天开单打卡奖励配置Remote
 * @author zhanghuifeng
 * date 2020/11/19-13:28
 */
@AdvancedFeignClient
public interface RemoteBillingClockAwardConfService {

    /**
     * 根据奖品配置类型查询
     * @param dateType 奖励配置类型 {@link BillingClockAwardConfTypeEnum}
     * @return
     */
    List<BillingClockAwardConfDto> listByType(Integer dateType);

    /**
     * 根据主键ID集合查询列表
     * @param ids 主键ID集合
     * @return 列表
     */
    List<BillingClockAwardConfDto> findByIds(List<Long> ids);
}
