package cn.com.duiba.kjy.api.remoteservice.billing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.billing.BillingClockReissueTicketDrawDto;

import java.util.List;

/**
 * 代理人开单打卡补卡券领取记录remote
 * @author zhanghuifeng
 * date 2020/11/23-15:03
 */
@AdvancedFeignClient
public interface RemoteBillingClockReissueTicketDrawService {


    /**
     * 领取补卡券
     * @param sellerId  代理人ID
     * @param reissueTicketConfId  补卡券配置ID
     * @return 结果
     */
    Boolean drawReissueTicket(Long sellerId, Long reissueTicketConfId);

    /**
     * 根据代理人ID和补卡券配置ID集合查询
     * @param sellerId  代理人ID
     * @param reissueTicketConfIds 补卡券配置ID，tb_billing_clock_reissue_ticket_conf主键ID
     * @return
     */
    List<BillingClockReissueTicketDrawDto> findBySellerTicketConfIds(Long sellerId, List<Long> reissueTicketConfIds);


}
