package cn.com.duiba.kjy.api.dto.dailypostersconfig;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author linjianhui
 * @description 早晚安图库
 * @date 2020/11/13 14:04
 */
@Data
public class DailyPostersGalleryDto implements Serializable {

    private static final long serialVersionUID = 7100528419183741844L;
    /**
     *
     *主键ID
     */
    private Long id;

    /**
     *
     *图片配置：大图
     * max length = 512
     */
    private String imageUrlConfig;

    /**
     * 图库类型，1：早安图库 2:晚安图库
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.GalleryTypeEnum
     */
    private Integer galleryType;

    /**
     *
     * 分类
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.GalleryClassifyEnum
     */
    private Integer galleryClassify;

    /**
     * 是否置顶
     *
     */
    private Integer stickState;

    /**
     * 是否推荐
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.RecommendEnum
     */
    private Integer recommend;

    /**
     * 图片使用人数
     * 基础值为5000-10000的随机数，然后每被使用一次 +1
     */
    private Integer useNum;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}