package cn.com.duiba.kjy.api.enums.billing;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/11/22-20:03
 */
public enum ForwardContentTypeToClockTaskTypeEnum {

    USE_GAME_ANSWER(ContentTypeEnum.GAME_ANSWER.getCode(),BillingClockTaskTypeEnum.USE_TEST_TOOL.getCode(), "使用趣味测试工具"),
    USE_LOTTERY_TOOL(ContentTypeEnum.GAME_LOTTERY.getCode(),BillingClockTaskTypeEnum.USE_LOTTERY_TOOL.getCode(), "使用抽奖工具"),
    USE_GAME_TEMPLATE(ContentTypeEnum.GAME_TEMPLATE.getCode(),BillingClockTaskTypeEnum.USE_LOTTERY_TOOL.getCode(), "使用抽奖工具"),
    FORWARD_DAILY(ContentTypeEnum.DAILY.getCode(),BillingClockTaskTypeEnum.FORWARD_DAILY.getCode(), "转发早报"),
    ;

    private String contentType;
    private Integer taskType;
    private String desc;

    ForwardContentTypeToClockTaskTypeEnum(String contentType, Integer taskType, String desc) {
        this.contentType = contentType;
        this.taskType = taskType;
        this.desc = desc;
    }

    private static final Map<String, ForwardContentTypeToClockTaskTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ForwardContentTypeToClockTaskTypeEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getContentType(), stateEnum);
        }
    }

    public static ForwardContentTypeToClockTaskTypeEnum getByContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return ENUM_MAP.get(contentType);
    }
    public String getContentType() {
        return contentType;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public String getDesc() {
        return desc;
    }
}
