package cn.com.duiba.kjy.api.enums.guide;

import cn.com.duiba.kjy.api.util.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Tips展示页面枚举
 * @Author chentiecheng
 * @Date 2020/6/1 4:58 下午
 */
public enum TipsShowPageEnum {
    INDEX("index",1,"首页"),
    SELLER_CARD("seller_card",2,"我的名片"),
    WHO_SAW_ME("who_saw_me",3,"谁看过我"),
    MATERIAL_CONTENT("material_content",4,"发圈素材"),
    EXPLOSION_CONTENT("explosion_content",5,"种草素材"),
    GREETING_CARD("greeting_card",6,"心意贺卡"),
    INVITATION_LETTER("invitation_letter",7,"邀请函"),
    GAME_LOTTERY("game_lottery",8,"抽奖游戏"),
    UPLOAD_LINK("upload_link",9,"上传链接"),
    GAME_ANSWER("game_answer",10,"趣味测试"),
    COMPANY_AREA("company_area",11,"公司专区"),
    SUCCESS_CASE("success_case",12,"成功案例"),
    DATA_BOARD("data_board",13,"数据看板"),
    PERSONAL_CENTER("personal_center",14,"个人中心"),
    ;
    private String code;
    /**
     * 所在switches的位置
     */
    private Integer slot;
    private String desc;

    TipsShowPageEnum(String code, Integer slot, String desc) {
        this.code = code;
        this.slot = slot;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public Integer getSlot() {
        return slot;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取枚举
     * @param code
     * @return
     */
    public static TipsShowPageEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }

        for(TipsShowPageEnum enums:TipsShowPageEnum.values()){
            if(StringUtils.equals(enums.getCode(),code)){
                return enums;
            }
        }
        return null;
    }

    /**
     * 根据switches值获取code列表值
     * @param switches
     * @return
     */
    public static List<String> getCodeListBySwitches(Long switches){
        if(NumberUtil.isNullOrLteZero(switches)){
            return Collections.emptyList();
        }
        List<String> results = new ArrayList<>();
        for(TipsShowPageEnum enums:TipsShowPageEnum.values()){
            if((switches & 1 << (enums.getSlot()-1)) > 0L){
                results.add(enums.code);
            }
        }
        return results;
    }

    /**
     * 根据code列表值获取switches值，switches由二进制转换而来
     * @param codes
     * @return
     */
    public static Long getSwitchesByCodes(List<String> codes){
        if(CollectionUtils.isEmpty(codes)){
            return 0L;
        }
        Long switches = 0L;
        for(TipsShowPageEnum enums:TipsShowPageEnum.values()){
            if(codes.contains(enums.getCode())){
                switches = switches | 1<< (enums.getSlot() - 1);
            }
        }
        return switches;
    }
}
