package cn.com.duiba.kjy.api.params.push;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2019-08-06 15:03
 * @description: 推送管理查询参数
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class PushManagerSearchParam extends PageQuery {

    private static final long serialVersionUID = -1611581461211620046L;
    private String title;
    private Date start;
    private Date end;
    private Long itemId;

    private Long pushId;
    /**
     * 推送场景类型
     * @see cn.com.duiba.kjy.api.enums.push.PushManagerSceneEnum
     */
    private Integer scenes;

    /**
     * 是否已删除
     */
    private Integer deleted;

    /**
     * 发送的公司id
     */
    private Long companyId;

    /**
     * 是否启用
     */
    private Integer isEnable;

    /**
     * 状态
     */
    private Integer state;

}
