package cn.com.duiba.kjy.api.remoteservice.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.home.SellerSubscriptionsDto;
import cn.com.duiba.kjy.api.params.home.SaveSellerSubscriptionParam;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-04-08 17:19
 * @description: 销售置顶公众号关联
 */
@AdvancedFeignClient
public interface RemoteSellerSubscriptionService {

    /**
     * 代理人置顶/取消置顶公众号
     * @param param
     * @return
     */
    Boolean stickyOnTop(SaveSellerSubscriptionParam param);

    /**
     * 根据代理人id和标签id获取置顶的公众号
     * subTagId 如果小于等于0，则查询全部的
     * @param sellerId 代理人id
     * @param subTagId 标签id
     * @return
     */
    List<SellerSubscriptionsDto> findSellerSubscriptions(Long sellerId,Long subTagId);

    /**
     * 根据销售id和公众号id查询关注信息
     * @param sellerId
     * @param subId
     * @return
     */
    SellerSubscriptionsDto findBySellerIdAndSubId(Long sellerId,Long subId);

}
