package cn.com.duiba.kjy.api.enums.explosioncontent;

/**
 * @author wangbinbin
 * @create 2020-05-21 14:41
 * @descript 种草素材资源位资源类型
 */
public enum ExplosionContentResourceTypeEnum {

    VOTE(1, "投票"),
    PRODUCT_ARTICLE(2, "产品文章"),
    RISK_TEST(3, "风险评测"),
    FAQ(4, "FAQ"),
    CLAIM_CASE(5, "理赔案例"),
    HEADWORD(6, "词条"),
    MATERIAL(7,"资料包"),
    INSURE_ADVICE(8,"投保咨询")
    ;

    private Integer code;

    private String description;

    ExplosionContentResourceTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static ExplosionContentResourceTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ExplosionContentResourceTypeEnum sourceTypeEnum : ExplosionContentResourceTypeEnum.values()) {
            if (sourceTypeEnum.getCode().equals(code)) {
                return sourceTypeEnum;
            }
        }
        return null;
    }
}
