package cn.com.duiba.kjy.api.enums.greeting;

import cn.com.duiba.kjy.api.enums.pay.WxCompanyPayErrorCodeEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/3/23 10:02
 */
public enum GreetingRedPacketFailCodeEnum {

    NOT_REAL_NAME("50001", "客户的微信支付未实名认证"),

    ABOVE_AMOUNT("50002", "由于微信限制，一个客户领取红包金额不可超过800元/月"),

    SYSTEM_FAIL("50003", "暂时失败，请稍后重新发送贺卡"),

    NO_MORE("50004", "红包已领完"),

    ;

    private String code;
    private String desc;

    GreetingRedPacketFailCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, GreetingRedPacketFailCodeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GreetingRedPacketFailCodeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static GreetingRedPacketFailCodeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    /**
     * 根据微信企业支付错误码获取客集集失败码
     * 注：目前只需要判断是否是未实名错误码
     * @param errorCode 微信企业支付错误码
     * @return
     */
    public static String getByErrorCode(String errorCode){
        if (WxCompanyPayErrorCodeEnum.V2_ACCOUNT_SIMPLE_BAN.getCode().equals(errorCode)){
            return NOT_REAL_NAME.getCode();
        }

        return SYSTEM_FAIL.getCode();
    }



    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
