package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.GrabContentDto;
import cn.com.duiba.kjy.api.dto.GrabContentExt.GrabContentKxbExtDto;
import cn.com.duiba.kjy.api.params.GrabContentAnalyzeParam;
import cn.com.duiba.kjy.api.params.GrabContentKxbParam;
import cn.com.duiba.kjy.api.params.GrabContentParam;
import cn.com.duiba.kjy.api.params.Page;

import java.util.List;

/**
 * Created by dugq on 2019-04-24.
 */
@AdvancedFeignClient
public interface RemoteGrabContentService {
    GrabContentDto selectOne(Long id);

    /**
     * 根据url查询最近的一条记录的ID
     * @param sourceUrl
     * @return
     */
    Long countBySourceUrl(String sourceUrl);

    List<GrabContentDto> selectList(GrabContentParam pojo);

    int update(GrabContentDto record);

    Integer selectCount(GrabContentParam pojo);

    Long insert(GrabContentDto pojo);

    int insertKxb(GrabContentKxbExtDto pojo);

    Integer delete(Long id);

    /**
     * 把爬虫库的文章移动到文章库
     * @param id
     * @return
     * @throws KjyCenterException
     */
    Long moving2ArticleList(Long id) throws KjyCenterException;

    /**
     * 下一篇文章
     * @param id
     * @param firstSign
     * @param secondSign
     * @param contentLocation
     * @return
     */
    GrabContentDto nextContent(Long id, String firstSign, String secondSign, Integer contentLocation);


    /**
     * 获取所有公司筛选项(保险产品素材)
     * @return
     */
    List<String>  getAllCompany();

    /**
     * 获取所有险种筛选项(保险产品素材)
     * @return
     */
    List<String>  getAllInsurancePolices(String company);

    /**
     * 获取所有产品筛选项(保险产品素材)
     * @return
     */
    List<String> getAllProduct(String company);

    /**
     * 获取列表(保险产品素材)
     * @param grabContentKxbParam
     * @return
     */
    Page<GrabContentKxbExtDto> selectPage(GrabContentKxbParam grabContentKxbParam);

    /**
     * 根据爬虫库Id或者文章Id获取产品素材元数据
     * @param grabContentId
     * @param contentId
     * @return
     */
    GrabContentKxbExtDto  selectByGrabContentIdOrContentId(Long grabContentId,Long contentId);

    /**
     * 爬虫文章解析
     * @param param
     * @return
     */
    Boolean grabContentAnalyze(GrabContentAnalyzeParam param);

}
