package cn.com.duiba.kjy.api.enums.billing;

import java.util.HashMap;
import java.util.Map;

/**
 * 60天开单打卡奖励领取状态
 * @author zhanghuifeng
 * date 2020/11/18-14:49
 */
public enum BillingClockDrawStateEnum {

    NOT_ENOUGH(0,"未满足领取条件"),
    UNCLAIMED(1, "待领取"),
    RECEIVED(2, "已领取"),

    ;

    private Integer code;
    private String desc;

    BillingClockDrawStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BillingClockDrawStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BillingClockDrawStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static BillingClockDrawStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
