package cn.com.duiba.kjy.api.enums.config;

/**
 * 键值对key枚举
 * 用于 tb_key_to_val_conf表中的key字段的前缀
 * @author 吴文哲
 * @date 2020-08-11 10:07
 **/
public enum KeyToValEnum {
    K020("名片新手引导"),
    K027("访客是否访问过新功能"),
    K033("付费代理新手链路引导"),
    K022("全网链接链接地址"),
    K034("用户导师"),
    K039("记录代理人每天首页弹层情况"),
    K040("首页弹层配置公司id数组"),
    K042("会员续费首次弹窗"),
    K043("本周期弹出弹层或进入续费支付页缓存"),
    K044("会员续费弹窗次数"),
    K045("非微信好友标记"),
    K050("文章二次编辑,编辑按钮上的文字tip"),
    K055("访客保存代理人通讯录行为"),
    K056("访客通讯录保存行为"),
    K059("用户觉得FAQ是否有用"),
    K063("访问记录额外信息"),
    K064("新功能弹层"),
    K065("用户个人产品key信息"),
    K066("用户个人产品"),
    K067("私聊二维码"),
    K068("活动统计数据"),
    K069("抽奖参与次数"),
    K070("抽奖分享次数"),
    K071("引导销售员关注VIP公众号推送"),
    ;

    private String desc;

    KeyToValEnum(String desc){
        this.desc = desc;
    }

    private static final String SPACE = "kjy_k2v";
    private static final String SEPARATOR = "_";

    public String getDesc() {
        return desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
