package cn.com.duiba.kjy.api.remoteservice.datagram;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.datagram.DatagramAddUpdateDto;
import cn.com.duiba.kjy.api.dto.datagram.DatagramArticleDto;
import cn.com.duiba.kjy.api.dto.datagram.DatagramExtDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-10-20 10:30
 * @descript 资料包remoteService
 */
@AdvancedFeignClient
public interface RemoteDatagramService {

    /**
     * 新增资料包
     * @param datagramAddUpdateDto
     * @return
     */
    Long saveDatagramExtDto(DatagramAddUpdateDto datagramAddUpdateDto);

    /**
     * 更新资料包
     * @param datagramAddUpdateDto
     * @return
     */
    int updateDatagramExtDto(DatagramAddUpdateDto datagramAddUpdateDto);

    /**
     * 更新资料包状态
     * @param id
     * @return
     */
    int updateStatus(Long id ,Integer status);

    /**
     * 创建
     * @param articleDtos
     * @param datagramContentId
     * @return
     */
    int saveOrUpdateDatagramArticle(List<DatagramArticleDto> articleDtos, Long datagramContentId);

    /**
     * 根据资料包id删除
     * @param id
     * @return
     */
    int deleteDatagramById(Long id);

    /**
     * 根据资料包id获取
     * @param id
     * @return
     */
    DatagramExtDto getById(Long id);

    /**
     * 根据资料包contentId查询资料包下的文章列表
     * @param datagramContentId
     * @return
     */
    List<DatagramArticleDto> listArticlesByDatagramContentId(Long datagramContentId);

    /**
     * 根据焦虑类型查询列表
     * @param anxietyType
     * @return
     */
    List<DatagramExtDto> listByAnxietyType(Integer anxietyType);


    /**
     * 根据焦虑类型查询列表（管理后端使用，查询开启和未开启的所有资料包）
     * @param anxietyType
     * @return
     */
    List<DatagramExtDto> listAllByAnxietyTypeForBack(Integer anxietyType);


    /**
     * 查询所有的资料包列表
     * @return
     */
    List<DatagramExtDto> listAllDatagram();

    /**
     * 根据内容id查询资料包
     * @param contentId
     * @return
     */
    DatagramExtDto findByContentId(Long contentId);

    /**
     * 寻找资料包文章的上一篇
     * @param datagramContentId
     * @param currentId
     * @return
     */
    Long findPreArticleId(Long datagramContentId, Long currentId);

    /**
     * 寻找资料包文章的下一篇
     * @param datagramContentId
     * @param currentId
     * @return
     */
    Long findNextArticleId(Long datagramContentId, Long currentId);

    /**
     * 根据资料包内容id和资料包文章内容id查询记录
     * @param datagramContentId
     * @param articleContentId
     * @return
     */
    DatagramArticleDto findArticleByIds(Long datagramContentId, Long articleContentId);

    /**
     * 根据内容id查询列表
     * @param contentIds
     * @return
     */
    List<DatagramExtDto> listByContentIds(List<Long> contentIds);

    /**
     * 查询资料包下文章数
     * @param datagramContentId
     * @return
     */
    int countArticleByDatagramContentId(Long datagramContentId);

    /**
     * 查询资料包总数
     * @return
     */
    int countAllDatagram();

    /**
     * 根据资料包文章获取资料包的内容id
     * @param articleContentId
     * @return
     */
    Long getDatagramContentIdByArticleContentId(Long articleContentId);

}
