package cn.com.duiba.kjy.api.dto.sourcereload;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 爬虫资源重试表
 * @author kjj mybatis generator 
 * 2020-05-20
 */
@Data
public class SourceReloadDto implements Serializable {
    private static final long serialVersionUID = 15899540339921662L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *资源来源地址
     * max length = 512
     */
    private String refUrl;

    /**
     *
     *资源地址
     * max length = 512
     * not null default = null
     */
    private String sourceUrl;

    /**
     *
     *oss地址
     * max length = 256
     * not null default = null
     */
    private String ossUrl;

    /**
     *
     *重试次数
     */
    private Integer retryNum;

    /**
     *
     *资源类型,1图片，2视频，3音频
     * not null default = null
     */
    private Integer sourceType;

    /**
     *
     *请求头
     * max length = 1024
     */
    private String headers;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     *
     *任务ID tb_seller_import_task.id
     */
    private Long taskId;

    /**
     *
     *当前解析之后的文章Id
     */
    private Long contentId;
}