package cn.com.duiba.kjy.api.enums.preInsatll;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by dugq on 2020-04-27.
 */
public enum PrePhoneEnum {
    NOT_PRE(0, "不预设手机号"),
    PRE_PHONE(1,"预设手机号。"),
    ;

    private Integer code;
    private String desc;

    PrePhoneEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, PrePhoneEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PrePhoneEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static PrePhoneEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }
}
