package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 代理人已读tips管理
 * @Author chentiecheng
 * @Date 2020/6/2 11:34 上午
 */
@AdvancedFeignClient
public interface RemoteSellerTipsReadService {
    /**
     * 根据代理人获取已读的tips id
     * @param sellerId
     * @return
     */
    List<Long> getSellerReadTipsIdBySellerId(Long sellerId);

    /**
     * 新增代理人Tips已读记录
     * @param sellerId
     * @param tipsId
     * @return
     */
    Boolean insertSelelrTipsRead(Long sellerId,Long tipsId);
    /**
     * 根据销售id和tipsId查询总数
     * @param sellerId 销售id
     * @param tipsId tipsId
     * @return
     */
    Integer count(Long sellerId,Long tipsId);
}
