package cn.com.duiba.kjy.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.crm.CrmSellerCustomerAbutmentDto;

import java.util.List;

/**
 * 销售CRM客户对接人信息remote
 * @author zhanghuifeng
 * date 2020/12/4-17:37
 */
@AdvancedFeignClient
public interface RemoteCrmSellerCustomerAbutmentService {

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean add(CrmSellerCustomerAbutmentDto dto);

    /**
     * 根据公司ID查询对接人列表(未删除)
     * @param crmCompanyId crm公司ID
     * @return 列表
     */
    List<CrmSellerCustomerAbutmentDto> findByCompanyId(Long crmCompanyId);

    /**
     * 删除（软删）
     * @param id 主键ID
     * @return
     */
    Boolean delById(Long id);

    /**
     * 根据主键ID查询信息
     * @param id 主键ID
     * @return 信息
     */
    CrmSellerCustomerAbutmentDto findById(Long id);
}
