package cn.com.duiba.kjy.api.enums.greeting;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liuchao1
 * @date 2020/1/7 20:59
 */
public enum GreetingCardRecordReceiveEnum {

    NOT_RECEIVE(0, "未领取"),

    RECEIVE_SUCCESS(1, "领取成功"),

    RECEIVE_FAIL(2, "领取失败"),

    RECEIVING(3, "领取中"),

    RECEIVE_TIME_OUT(4, "超过3小时，还是中间状态"),

    RECEIVE_TIME_OUT_SUCCESS(5, "超过3小时后，领取成功"),

    RECEIVE_TIME_OUT_FAIL(6, "超过3小时后，领取失败"),
    ;

    private Integer code;
    private String desc;

    GreetingCardRecordReceiveEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, GreetingCardRecordReceiveEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GreetingCardRecordReceiveEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static GreetingCardRecordReceiveEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public boolean isFinalState() {
        return this == RECEIVE_SUCCESS || this == RECEIVE_FAIL
                || this == RECEIVE_TIME_OUT_SUCCESS || this == RECEIVE_TIME_OUT_FAIL;
    }

    public boolean isTimeOut() {
        return this == RECEIVE_TIME_OUT || this == RECEIVE_TIME_OUT_SUCCESS || this == RECEIVE_TIME_OUT_FAIL;
    }

    public boolean isFail() {
        return this == RECEIVE_FAIL || this == RECEIVE_TIME_OUT_FAIL;
    }

    public boolean isSuccess() {
        return this == RECEIVE_SUCCESS || this == RECEIVE_TIME_OUT_SUCCESS;
    }
}
