package cn.com.duiba.kjy.api.enums.honorary;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/3/17 9:13 PM
 */
public enum HonoraryConfStateEnum {

    PREVIEW(0, "预览"),
    PRODUCE(1, "正式"),
    ;

    private Integer type;

    private String desc;

    HonoraryConfStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, HonoraryConfStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(HonoraryConfStateEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static HonoraryConfStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
