package cn.com.duiba.kjy.api.params.crm;

import cn.com.duiba.kjy.api.enums.crm.CrmSellerBizTypeEnum;
import cn.com.duiba.kjy.api.enums.crm.CrmSellerRoleTypeEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author linjianhui
 * @description  crm销售查询参数
 * @date 2020/12/8 18:53
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CrmSellerQryParam extends PageQuery {

    private static final long serialVersionUID = -2929221176513624423L;
    /**
     * 销售名称
     */
    private String sellerName;

    /**
     * 角色类型，1销售,2管理员
     * @see CrmSellerRoleTypeEnum
     */
    private Integer roleType;

    /**
     * 业务类型，1直播线
     * @see CrmSellerBizTypeEnum
     */
    private Integer bizType;
}
